
using System;
using System.Collections.Generic;
using System.Text;
using Gemini.Core.BL.Interface.DBD;

namespace PI.ZB.N1200.ELearning.BL.DAL
{
    internal class Student : PI.FM.N000.Base.BL.DAL.BaseTable<DBD.Student, BO.Student>
    {

        internal Student(Gemini.Core.BL.Interface.IBusinessLogicPlugIn BusinessLogicPlugIn) : this(BusinessLogicPlugIn.Environment, BusinessLogicPlugIn.DriverName) { }

        internal Student(Gemini.Core.BL.Interface.DAL.IEnvironment Environment, string DriverName) : base(Environment, DriverName, DBD.Student.DBD) { }

        internal BO.Student RestoreTopOne(BO.Student.Search Search)
        {
            return InternalRestoreOne((int)DBD.Student.Commands.RestoreBySearch,
            delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
            {
                Command["ClassID"].Value = Search.ClassID;
                Command["IndexNr"].Value = Search.IndexNr;
                Command["InstructorID"].Value = Search.InstructorID;
                Command["SchoolID"].Value = Search.SchoolID;
                Command["SchoolYearID"].Value = Search.SchoolYearID;
                Command["SortOrderID"].Value = Search.SortOrderID;
                Command["UserID"].Value = Search.UserID;
            });
        }

        internal List<BO.Student> Restore(BO.Student.Search Search)
        {
            return InternalRestoreList((int)DBD.Student.Commands.RestoreBySearch,
            delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
            {
                Command["ClassID"].Value = Search.ClassID;
                Command["IndexNr"].Value = Search.IndexNr;
                Command["InstructorID"].Value = Search.InstructorID;
                Command["SchoolID"].Value = Search.SchoolID;
                Command["SchoolYearID"].Value = Search.SchoolYearID;
                Command["SortOrderID"].Value = Search.SortOrderID;
                Command["UserID"].Value = Search.UserID;
            });
        }

        internal int Count(BO.Student.Search Search)
        {
            Gemini.Core.BL.Interface.DBD.ICommand _command = InternalExecuteScalar((int)DBD.Student.Commands.CountBySearch,
                delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
                {
                    Command["ClassID"].Value = Search.ClassID;
                    Command["IndexNr"].Value = Search.IndexNr;
                    Command["InstructorID"].Value = Search.InstructorID;
                    Command["SchoolID"].Value = Search.SchoolID;
                    Command["SchoolYearID"].Value = Search.SchoolYearID;
                    Command["UserID"].Value = Search.UserID;
                });

            if (_command != null)
            {
                return Convert.ToInt32(_command["Result"].Value);
            }
            return 0;
        }

        internal bool Remove(BO.Student.Search Search)
        {
            bool _return = false;
            Gemini.Core.BL.Interface.DBD.ICommand _command = InternalExecuteScalar((int)DBD.Student.Commands.RemoveBySearch,
            delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
            {
                Command["ClassID"].Value = Search.ClassID;
                Command["IndexNr"].Value = Search.IndexNr;
                Command["InstructorID"].Value = Search.InstructorID;
                Command["SchoolID"].Value = Search.SchoolID;
                Command["SchoolYearID"].Value = Search.SchoolYearID;
                Command["UserID"].Value = Search.UserID;
                Command["EditDate"].Value = DateTime.Now;
                Command["EditUser"].Value = Environment.User.ID;
            });

            if (_command != null)
            {
                if (_command.ResultParam != null)
                {
                    _return = _command.ResultParamValue >= 0 ? true : false;
                }
                else
                {
                    _return = true;
                }
            }
            return _return;
        }
    }
}